VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Digital Channels on 7707"
   ClientHeight    =   5910
   ClientLeft      =   2760
   ClientTop       =   1695
   ClientWidth     =   6000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5910
   ScaleWidth      =   6000
   Begin VB.CommandButton cmdDigitalInput 
      Caption         =   "Read Channel 111"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   10
      Top             =   2400
      Width           =   2055
   End
   Begin VB.TextBox txtDOValue 
      Height          =   285
      Left            =   3000
      TabIndex        =   9
      Text            =   "0"
      ToolTipText     =   "Enter Integer value between 0 and 255"
      Top             =   3000
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Channel 111"
      Height          =   975
      Left            =   3120
      TabIndex        =   6
      Top             =   1080
      Width           =   1455
      Begin VB.OptionButton Option2 
         Caption         =   "Input"
         Height          =   195
         Left            =   240
         TabIndex        =   8
         Top             =   600
         Width           =   975
      End
      Begin VB.OptionButton optOut 
         Caption         =   "Output"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdConfigure 
      Caption         =   "Configure Channel 111"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   5
      Top             =   1440
      Width           =   2055
   End
   Begin VB.CommandButton cmdDigitalOutput 
      Caption         =   "Write Channel 111"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   3000
      Width           =   2055
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Session"
      Height          =   375
      Left            =   600
      TabIndex        =   2
      Top             =   840
      Width           =   2055
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   615
      Left            =   4920
      TabIndex        =   1
      Top             =   5040
      Width           =   855
   End
   Begin VB.Label lblDIValue 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   3000
      TabIndex        =   11
      Top             =   2400
      Width           =   855
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   480
      TabIndex        =   3
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   495
      Left            =   360
      TabIndex        =   0
      Top             =   4200
      Width           =   4935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' this example was tested in VB6 in Win2K SP4
' using IVI driver Version 2700-852B01.3
' with a 2700 FW B06 and a 7707 card in slot 1
'
'
Option Explicit
Dim vi As ViSession
Dim status As ViStatus
Dim readingArray(50) As ViReal64
Dim arraySize As ViInt32, maxTime As ViInt32, actualPts As ViInt32
' Uncomment or redefine one of the following lines to select
' other communication bus types

' For RS-232 bus COM2
'Private Const InstrumentName = "ASRL2::INSTR"

' For GPIB bus,
'Private Const InstrumentName = "GPIB0::16::INSTR"

' For RS-232 bus COM1
Private Const InstrumentName = "ASRL1::INSTR"

Private Sub cmdConfigure_Click()
'KE2700_ATTR_DIGITAL_PORT_STATE  ' 0 = output, 1 = input
If optOut.Value = True Then
CheckError vi, KE2700_SetAttributeViInt32(vi, "111", KE2700_ATTR_DIGITAL_PORT_STATE, 0)
cmdDigitalOutput.Enabled = True  ' if an output, enable write button
Else
CheckError vi, KE2700_SetAttributeViInt32(vi, "111", KE2700_ATTR_DIGITAL_PORT_STATE, 1)
cmdDigitalOutput.Enabled = False ' if an input, disable write button
End If
End Sub

Private Sub cmdDigitalInput_Click()
Dim DIValue As ViInt32
CheckError vi, KE2700_GetAttributeViInt32(vi, _
                                        "111", _
                                        KE2700_ATTR_DIGITAL_PORT_BYTE_VALUE, _
                                        DIValue)
lblDIValue.Caption = Str(DIValue)
End Sub

Private Sub cmdDigitalOutput_Click()

' digital channels are 111, 112, 113, 114 assuming 7707 is in slot 1

'CheckError vi, KE2700_SetAttributeViInt32(vi, _
'                                          "111", _
'                                          KE2700_ATTR_DIGITAL_PORT_BYTE_VALUE, _
'                                          CInt(txtDOValue))
                                          
' the above works or use the function call below to write a digital channel

CheckError vi, KE2700_WritePort(KE2700_ChannelList(vi, "111"), _
                                KE2700_VAL_PORT_BYTE, _
                                CInt(txtDOValue))

End Sub

Private Sub cmdExit_Click()
CloseDevice vi
End
End Sub

Private Sub cmdInit_Click()
 On Error GoTo Errorhandler
  lblStatus.Caption = "Trying to open session for " & InstrumentName
  DoEvents
  
    vi = OpenDevice
    
    cmdDigitalInput.Enabled = True
    cmdConfigure.Enabled = True
    lblStatus.Caption = "Session established"
   
  Exit Sub

Errorhandler:
  If Err.Number <> 0 Then
    lblStatus.Caption = Err.Description
  End If
  CloseDevice vi
  'lblStatus.Caption = "Done"
End Sub


' Routine:
'   OpenDevice

' Purpose:
'   Opens a physical or simulated instrument.
'   Define InstrumentName const to select instrument.
'   Define Simulate const to select physical or simulated instrument.

' Return:
'   VISA instrument session handle

' Exception:
'   If OpenDevice fails, it throws error to caller using CheckError

Public Function OpenDevice() As ViSession
 
  status = KE2700_InitWithOptions(InstrumentName, VI_TRUE, _
                                  VI_TRUE, _
                                  "Simulate=0,RangeCheck=1,QueryInstrStatus=1,Cache=1", _
                                  vi)
  OpenDevice = vi
  CheckError vi, status
End Function

' Routine:
'   CloseDevice

' Purpose:
'   Closes a previously opened instrument

' Return:
'   None

' Exception:
'   If CloseDevice fails, it throws error to caller using CheckError

Public Sub CloseDevice(ByVal vi As ViSession)
  Dim Error As ViStatus
  Error = VI_SUCCESS
  If vi <> 0 Then Error = KE2700_close(vi)
  CheckError vi, Error
End Sub



' Routine:
'   CheckError

' Purpose:
'   This routine checks the return value of the given IVI function call.
'   It constructs an error message if an error occurs.

'   If the ErrorCode is greater than &HBFFF0000, then the error is reported by the IVI
'   Driver, otherwise, it's reported directly from the hardware instrument.
'   For errors reported by IVI Driver, use KE2700_error_message to retrieve the error code.
'   For errors reported by instruments, use KE2700_query_error

' Return:
'  None

' Exception:
'   If <ErrorCode> does indicate an error condition, then a constructed error is raised
'   to the caller.

Public Sub CheckError(ByVal vi As ViSession, ByVal ErrorCode As ViStatus)
  Dim ErrMsg As String
  Dim buffer As String
  Dim ErrCode As ViStatus
  Dim PrimaryErr As ViStatus
  Dim SecondaryErr As ViStatus
  Dim ElaborationErr As String

  If ErrorCode = VI_SUCCESS Then Exit Sub
  ErrMsg = ErrMsg & "Primary Error: (Hex " & Hex(ErrorCode) & ")" & vbCrLf
  buffer = Space$(256)

  If ErrorCode <> &HBFFA0001 Then ' IVI_ERROR_INSTR_SPECIFIC =  &HBFFA0001
    ' Error reported by IVI Driver
    KE2700_error_message vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
    KE2700_GetErrorInfo vi, PrimaryErr, SecondaryErr, ElaborationErr
  
    If PrimaryErr = ErrorCode And SecondaryErr <> 0 Then
      ' Check secondary error if there is any
      ErrMsg = ErrMsg & "Secondary Error: (Hex " & Hex(SecondaryErr) & ")" & vbCrLf
      KE2700_error_message vi, SecondaryErr, buffer
      ErrMsg = ErrMsg & Trim$(buffer)
      ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
      ' Check Elaboration error if there is any
      If Len(ElaborationErr) Then
        ErrMsg = ErrMsg & "Elaboration: " & ElaborationErr
      End If
    End If

  Else
    ' Error reported by instrument.
    KE2700_error_query vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
  End If

  'if not a warning, Raise error to the caller
  If ErrorCode < 0 Then Err.Raise ErrorCode, "IVI Driver Examples", ErrMsg
End Sub


